@extends('layouts.base1')

@section('title', $settings->site_title)

@inject('content', 'App\Http\Controllers\FrontController')
@section('content')
<style>
    /* Global Styles */
    body {
        font-family: 'Arial', sans-serif;
        background-color: #f9f9f9;
        color: #333;
    }

    /* Header */
    .section-heading h2 {
        color: #1b2142;
        font-size: 2rem;
        font-weight: 600;
    }

    .track-section {
        background: #fff;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        margin-bottom: 30px;
    }

    /* Package Image */
    .package-image {
        max-width: 300px;
        border-radius: 12px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease;
    }

    .package-image:hover {
        transform: scale(1.05);
    }

    /* Track Progress */
    .progress-wrapper {
        background: #ddd;
        height: 20px;
        border-radius: 10px;
        overflow: hidden;
        margin-top: 15px;
        position: relative;
        box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.2);
    }

    .progress-bar {
        background-color: #005ea2; /* USPS Blue */
        height: 100%;
        width: 0;
        color: white;
        text-align: center;
        font-weight: bold;
        line-height: 20px;
        animation: fillProgressBar 3s ease-in-out forwards;
    }

    @keyframes fillProgressBar {
        0% { width: 0%; }
        100% { width: {{ $courier->percentage_complete }}%; }
    }

    /* Tables */
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th {
        background-color: #005ea2;
        color: white;
        font-weight: 600;
        padding: 10px;
        text-align: left;
    }

    td {
        padding: 12px;
        border: 1px solid #ddd;
        font-size: 14px;
    }

    tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    /* Buttons */
    .btn-success {
        background-color: #005ea2;
        color: white;
        font-weight: 600;
        padding: 10px 20px;
        border-radius: 8px;
        transition: all 0.3s ease;
    }

    .btn-success:hover {
        background-color: #00407d;
    }

    /* Media Queries */
    @media (max-width: 768px) {
        .section-heading h2 {
            font-size: 1.5rem;
        }

        table, th, td {
            font-size: 12px;
        }

        .progress-wrapper {
            height: 15px;
        }

        .progress-bar {
            line-height: 15px;
        }
    }
</style>

<section class="breadcrumb-area bg-img bg-overlay jarallax" style="background-image:url(temp/custom2/img/bg-img/13.jpg);">
    <div class="container h-100">
        <div class="row h-100 align-items-center">
            <div class="col-12">
                <div class="breadcrumb-content">
                    <h2>Tracking Result</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item active" aria-current="page">Tracking Page</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="post-news-area section-padding-100-0">
    <div class="container">
        <!-- Main Title Section -->
        <div class="section-heading text-center mb-5">
            <h2>Track Your Package</h2>
        </div>
<!-- Tracking Overview Section -->

    <!-- Tracking Progress Column -->
<div class="track-section">
    <h4><i class="fas fa-tasks"></i> Tracking Progress</h4>
    <div class="progress-bar-container">
        <div class="progress-bar-fill" id="progressBar">0%</div>
    </div>
</div>


<!-- Script to Animate Progress Bar and Number -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const targetPercent = {{ $courier->percentage_complete }};
        const progressBar = document.getElementById('progress-bar');
        const progressText = document.getElementById('progress-text');
        let count = 0;

        const interval = setInterval(() => {
            if (count <= targetPercent) {
                progressBar.style.width = count + '%';
                progressText.textContent = count + '%';
                count++;
            } else {
                clearInterval(interval);
            }
        }, 15); // Adjust speed here
    });
</script>


    <!-- Barcode + Invoice Column -->
    <div class="col-md-6">
        <div class="track-section text-center">
            <h4><i class="fas fa-barcode"></i> Tracking Details</h4>
            <p><strong>Tracking Number:</strong> {{ $courier->trackingnumber }}</p>
            <img src="https://barcode.tec-it.com/barcode.ashx?data={{ $courier->trackingnumber }}&code=Code128" alt="Barcode" class="barcode-img">
            <br>
            <a href="{{ route('printnow', $courier->id) }}" class="btn btn-success mt-3">
                <i class="fas fa-print"></i> Print Shipping Invoice
            </a>
        </div>
    </div>
</div>

<style>
.progress-wrapper {
    margin-top: 10px;
}

.progress-bar-container {
    width: 100%;
    background: #e0e0e0;
    border-radius: 50px;
    overflow: hidden;
    height: 45px;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.1);
    position: relative;
}

.progress-bar-fill {
    height: 100%;
    width: 0;
    background: linear-gradient(90deg, #00c6ff, #0072ff);
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 16px;
    border-radius: 50px;
    transition: width 0.4s ease-in-out;
}


.barcode-img {
    margin-top: 10px;
    max-width: 100%;
    height: auto;
}
</style>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const progressBar = document.getElementById("progressBar");
        const targetPercent = {{ $courier->percentage_complete }}; // Injected from server
        let current = 0;

        const interval = setInterval(() => {
            if (current >= targetPercent) {
                clearInterval(interval);
            } else {
                current++;
                progressBar.style.width = current + "%";
                progressBar.textContent = current + "%";
            }
        }, 20); // Speed of count
    });
</script>


<div class="row">
    <div class="col-md-6">
        <div class="track-section map-wrapper">
            <h4><i class="fas fa-map-marker-alt"></i> Current Location</h4>
            <div class="map-container">
                <iframe 
                    src="https://maps.google.com/maps?q={{ urlencode($courier->location) }}&output=embed" 
                    class="google-map"
                    allowfullscreen=""
                    loading="lazy"
                ></iframe>
                <div class="map-pointer">
                    <i class="fas fa-map-marker-alt"></i>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
.map-container {
    position: relative;
    width: 100%;
    height: 300px;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.google-map {
    width: 100%;
    height: 100%;
    border: none;
    filter: grayscale(10%) contrast(1.1);
}

.map-pointer {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -100%);
    font-size: 32px;
    color: red;
    animation: bounce 1.5s infinite;
}

@keyframes bounce {
    0%, 100% {
        transform: translate(-50%, -100%);
    }
    50% {
        transform: translate(-50%, -110%);
    }
}
</style>

    </div>
    <div class="col-md-6">
        <div class="track-section">
            <h4><i class="fas fa-user"></i> Receiver's Details</h4>
            <table>
                <tr><th><i class="fas fa-user"></i> Full Name</th><td>{{ $courier->name }}</td></tr>
                <tr><th><i class="fas fa-map-marker-alt"></i> Address</th><td>{{ $courier->address }}</td></tr>
                <tr><th><i class="fas fa-envelope"></i> Email</th><td>{{ $courier->email }}</td></tr>
                <tr><th><i class="fas fa-phone"></i> Phone</th><td>{{ $courier->phone }}</td></tr>
            </table>

            <h4><i class="fas fa-user-tie"></i> Sender's Details</h4>
            <table>
                <tr><th><i class="fas fa-user-tie"></i> Name</th><td>{{ $courier->sname }}</td></tr>
                <tr><th><i class="fas fa-map-marker-alt"></i> Address</th><td>{{ $courier->saddress }}</td></tr>
                <tr><th><i class="fas fa-envelope"></i> Email</th><td>{{ $courier->semail }}</td></tr>
                <tr><th><i class="fas fa-phone"></i> Phone</th><td>{{ $courier->sphone }}</td></tr>
            </table>
        </div>
    </div>
</div>

<!-- Tracking image -->

<div class="track-section">
    <h4><i class="fas fa-image"></i> Package Photos</h4>
    @if($courier->photo != null)
        <img src="{{ asset('storage/app/public/photos/' . $courier->photo) }}" class="package-image" alt="Package Photo">
        <p><strong><i class="fas fa-camera"></i> Package Image</strong></p>
    @endif
</div>


<!-- Consignment Information Section -->
<div class="track-section">
    <h4><i class="fas fa-box"></i> Consignment Info</h4>
    <table>
        <tr><th><i class="fas fa-weight-hanging"></i> Weight</th><td>{{ $courier->weight }}</td></tr>
        <tr><th><i class="fas fa-truck"></i> Status</th><td>{{ $courier->status }}</td></tr>
        <tr><th><i class="fas fa-cogs"></i> Service</th><td>{{ $courier->shipment_type }}</td></tr>
        <tr><th><i class="fas fa-truck-moving"></i> Delivery Mode</th><td>{{ $courier->freight_type }}</td></tr>
        <tr><th><i class="fas fa-tasks"></i> Completion</th><td>{{ $courier->percentage_complete }}%</td></tr>
        <tr><th><i class="fas fa-location-arrow"></i> Origin</th><td>{{ $courier->take_off_point }}</td></tr>
        <tr><th><i class="fas fa-map-pin"></i> Destination</th><td>{{ $courier->final_destination }}</td></tr>
        <tr><th><i class="fas fa-calendar-alt"></i> Expected Delivery</th><td>{{ \Carbon\Carbon::parse($courier->expected_delivery)->toDayDateTimeString() }}</td></tr>
    </table>
</div>


<div class="track-section">
    <h4>Tracking Updates</h4>
    <div class="timeline">
        @forelse ($tracks as $track)
        <div class="timeline-item status-{{ strtolower(str_replace(' ', '-', $track->status)) }}">
            <div class="timeline-marker">
                <div class="circle"></div>
            </div>
            <div class="timeline-content">
                <h5>{{ $track->status }}</h5>
                <div class="detail">
                    <i class="fas fa-map-marker-alt"></i>
                    <span class="label">Location:</span>
                    <p>{{ $track->address }}, {{ $track->city }}</p>
                </div>
                <div class="detail">
                    <i class="fas fa-flag"></i>
                    <span class="label">Country:</span>
                    <p>{{ $track->country }}</p>
                </div>
                <div class="detail">
                    <i class="fas fa-calendar-alt"></i>
                    <span class="label">Date:</span>
                    <p>{{ \Carbon\Carbon::parse($track->created_at)->toDayDateTimeString() }}</p>
                </div>
                <div class="detail">
                    <i class="fas fa-comment"></i>
                    <span class="label">Comment:</span>
                    <p>{{ $track->comment }}</p>
                </div>
            </div>
        </div>
        @empty
        <p class="text-center">No tracking updates available.</p>
        @endforelse
    </div>
</div>


<style>
   .track-section {
    margin-bottom: 30px;
    padding: 20px;
    background-color: #fff;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
}

.timeline {
    position: relative;
    padding-left: 40px;
    border-left: 2px solid #1b2142;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
}

.timeline-marker {
    position: absolute;
    left: -20px;
    top: 0;
    width: 20px;
    height: 20px;
    background-color: #1b2142;
    border-radius: 50%;
    border: 2px solid white;
    z-index: 1;
}

.timeline-content {
    padding-left: 40px;
    animation: fadeInUp 0.5s ease-out;
    width: 100%;
}

.timeline-content h5 {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 5px;
}

.timeline-content .detail {
    display: flex;
    align-items: center;
    margin-bottom: 10px;
}

.timeline-content .detail i {
    font-size: 18px;
    margin-right: 10px;
    color: #1b2142;
}

.timeline-content .detail .label {
    font-weight: bold;
    margin-right: 5px;
}

.timeline-content .detail p {
    font-size: 14px;
    margin: 0;
}

/* Status-Based Colors */
.status-shipped {
    background-color: #e6f0ff;
}

.status-shipped .timeline-content {
    border-left: 4px solid #15569C;
}

.status-out-for-delivery {
    background-color: #ffe6e6;
}

.status-out-for-delivery .timeline-content {
    border-left: 4px solid #ED192D;
}

.status-delivered {
    background-color: #e6ffe6;
}

.status-delivered .timeline-content {
    border-left: 4px solid #28a745;
}

.status-exception {
    background-color: #fff3cd;
}

.status-exception .timeline-content {
    border-left: 4px solid #fd7e14;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

</style>


<script>
    
    document.addEventListener("DOMContentLoaded", function () {
    const timelineItems = document.querySelectorAll(".timeline-item");
    timelineItems.forEach(item => {
        item.classList.add("fade-in");
    });
});

    
</script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">


            </table>

            
        </div>
    </div>
</section>


<tr class="expected-delivery-row">
    <th>
        <div class="delivery-title">
            <i class="fas fa-calendar-alt calendar-icon"></i>
            <span>Expected Delivery On</span>
        </div>
    </th>
    <td>
        <div class="delivery-info">
            <div class="delivery-date">
                <strong>{{ \Carbon\Carbon::parse($courier->expected_delivery)->toDayDateTimeString() }}</strong>
            </div>
            <p class="delivery-note">
                🎁 Sit back and relax! Your package is on schedule and expected to arrive in excellent condition. We appreciate your trust and patience throughout the delivery journey.
            </p>
        </div>
    </td>
</tr>

<style>
    
   .expected-delivery-row {
    border-top: 1px solid #ddd;
    padding: 12px 0;
}

.delivery-title {
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 600;
    font-size: 15px;
    color: #1b2142;
    padding-top: 10px;
}

.calendar-icon {
    color: #007bff;
    font-size: 18px;
    background-color: #e6f0ff;
    padding: 8px;
    border-radius: 50%;
    box-shadow: 0 2px 5px rgba(0, 123, 255, 0.2);
}

.delivery-info {
    background: linear-gradient(135deg, #e0f7fa, #e3f2fd);
    padding: 15px 18px;
    border-left: 4px solid #007bff;
    border-radius: 10px;
    font-size: 14px;
    color: #333;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    transition: all 0.3s ease;
}

.delivery-info:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.delivery-note {
    margin-top: 10px;
    font-style: italic;
    line-height: 1.6;
    color: #444;
}

.delivery-date {
    font-size: 16px;
    font-weight: bold;
    color: #1b2142;
}

    
</style>
<br><br>
@endsection
